<?php

namespace NGD_CCM\Front;

use NGD_CCM\App;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Front {

	public function __construct( $run_hooks = false ) {
		if ( $run_hooks ) {
			$this->run_hooks();
		}
	}

	public function run_hooks(): void {
		add_shortcode( 'cookiewatch_ccm_table', [ $this, 'render_cookiewatch_ccm_table' ] );
		add_action( 'wp_head', [ $this, 'header_code' ] );
	}

	public function render_cookiewatch_ccm_table(): bool|string {
		ob_start();
		?>
        <div class="ccm-cookie-declaration">
	        <?php
	        $link = "<a target='_blank' href='https://docs.cookiewatch.de/'>https://docs.cookiewatch.de</a>";
	        ?>
            <?php
	        /* translators: %s: $code = "<a target='_blank' href='https://docs.cookiewatch.de/'>https://docs.cookiewatch.de</a>" */
            echo sprintf(__('Please enable the %s script to view the cookie declaration table.', 'cookiewatch-ccm'), $link) ;

            ?>
        </div>
		<?php
		return ob_get_clean();
	}

	public function header_code(): void {
		$enable_script = get_option( 'cookiewatch_ccm_enable_script', false );
		if ( $enable_script ) {
			echo App::get_script_to_add();
		}
	}

}